/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscribers;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class SubscriberResourceWrapper<T>
extends AtomicReference<Disposable>
implements FlowableSubscriber<T>,
Disposable,
Subscription {
    private static final long serialVersionUID = -8612022020200669122L;
    final Subscriber<? super T> downstream;
    final AtomicReference<Subscription> upstream = new AtomicReference();

    public SubscriberResourceWrapper(Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, s)) {
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t) {
        this.downstream.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        DisposableHelper.dispose(this);
        this.downstream.onError(t);
    }

    @Override
    public void onComplete() {
        DisposableHelper.dispose(this);
        this.downstream.onComplete();
    }

    @Override
    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            this.upstream.get().request(n);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.upstream);
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public void setResource(Disposable resource) {
        DisposableHelper.set(this, resource);
    }
}

